/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.util.ValueUtil;
import org.lwjgl.input.Mouse;

public class GuiNpcSlider
extends GuiButton
implements IComponentGui,
IGuiNpcSlider {
    public boolean dragging;
    public boolean isVertical;
    public int field_146127_k;
    private final ISliderListener listener;
    public float sliderValue;
    private final List<String> hoverText = new ArrayList<String>();

    public GuiNpcSlider(ISliderListener parent, int id, int xPos, int yPos, float sliderValue) {
        this(parent, id, xPos, yPos, "", sliderValue);
        if (this.listener != null) {
            this.listener.mouseDragged(this);
        }
    }

    public GuiNpcSlider(ISliderListener parent, int id, int xPos, int yPos, int width, int height, float sliderValue) {
        this(parent, id, xPos, yPos, "", sliderValue);
        this.field_146120_f = width;
        this.field_146121_g = height;
        boolean bl = this.isVertical = height > width;
        if (this.listener != null) {
            this.listener.mouseDragged(this);
        }
    }

    public GuiNpcSlider(ISliderListener parent, int id, int xPos, int yPos, String displayString, float sliderValue) {
        super(id, xPos, yPos, 150, 20, NoppesStringUtils.translate(displayString));
        this.field_146127_k = id;
        this.sliderValue = sliderValue;
        this.listener = parent;
        this.field_146125_m = true;
    }

    @Override
    public void render(IEditNPC gui, int mouseX, int mouseY, float partialTicks) {
        this.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
        if (this.field_146123_n && !gui.hasSubGui() && !this.hoverText.isEmpty()) {
            gui.setHoverText(this.hoverText);
        }
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        int dWheel;
        if (!this.field_146125_m) {
            return;
        }
        mc.func_110434_K().func_110577_a(field_146122_a);
        GlStateManager.func_179131_c((float)2.0f, (float)2.0f, (float)2.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
        int w = this.field_146120_f;
        int h = this.field_146121_g;
        if (this.isVertical) {
            w = this.field_146121_g;
            h = this.field_146120_f;
        }
        boolean bl = this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        if (this.field_146123_n && (dWheel = Mouse.getDWheel()) != 0) {
            float f = (dWheel < 0 ? -1.0f : 1.0f) / (float)this.field_146120_f;
            float t = this.sliderValue + f;
            if (t < 0.0f) {
                t += 1.0f;
            } else if (t > 1.0f) {
                t -= 1.0f;
            }
            this.sliderValue = ValueUtil.correctFloat(t, 0.0f, 1.0f);
            if (this.listener != null) {
                this.listener.mouseDragged(this);
            }
        }
        if (this.isVertical) {
            GlStateManager.func_179109_b((float)h, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.func_73729_b(0, 0, 0, 46, w / 2, h);
        this.func_73729_b(w / 2, 0, 200 - w / 2, 46, w / 2, h);
        if (h < 20) {
            this.func_73730_a(0, w - 2, h - 1, -16777216);
        }
        GlStateManager.func_179121_F();
        this.func_146119_b(mc, mouseX, mouseY);
        if (this.field_146126_j.isEmpty()) {
            return;
        }
        int l = CustomNpcs.MainColor.getRGB();
        if (this.packedFGColour != 0) {
            l = this.packedFGColour;
        } else if (!this.field_146124_l) {
            l = CustomNpcs.NotEnableColor.getRGB();
        } else if (this.field_146123_n) {
            l = CustomNpcs.HoverColor.getRGB();
        }
        this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + 2 + (this.field_146121_g - ClientProxy.Font.height(this.field_146126_j)) / 2, l);
    }

    @Override
    public String getDisplayString() {
        return this.field_146126_j;
    }

    public int func_146114_a(boolean par1) {
        return 0;
    }

    public void func_146119_b(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (!this.field_146125_m) {
            return;
        }
        mc.func_110434_K().func_110577_a(field_146122_a);
        int w = this.field_146120_f;
        int h = this.field_146121_g;
        if (this.isVertical) {
            w = this.field_146121_g;
            h = this.field_146120_f;
        }
        if (this.dragging) {
            this.sliderValue = this.isVertical ? ValueUtil.correctFloat((float)(mouseY - (this.field_146129_i + 4)) / (float)(w - 8), 0.0f, 1.0f) : ValueUtil.correctFloat((float)(mouseX - (this.field_146128_h + 4)) / (float)(w - 8), 0.0f, 1.0f);
            if (this.listener != null) {
                this.listener.mouseDragged(this);
            }
            if (!Mouse.isButtonDown((int)0)) {
                this.func_146118_a(0, 0);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xPos = this.field_146128_h + (int)(this.sliderValue * (float)(w - 8));
        int yPos = this.field_146129_i;
        GlStateManager.func_179094_E();
        if (this.isVertical) {
            xPos = this.field_146128_h;
            yPos = this.field_146129_i + (int)(this.sliderValue * (float)(w - 8));
            GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)0.0f);
            GlStateManager.func_179109_b((float)h, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)0.0f);
        }
        this.func_73729_b(0, 0, 0, 66, 4, h);
        this.func_73729_b(4, 0, 196, 66, 4, h);
        if (h < 20) {
            this.func_73730_a(1, 6, h - 1, -16777216);
        }
        GlStateManager.func_179121_F();
    }

    public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146124_l && this.field_146125_m && this.field_146123_n) {
            this.sliderValue = ValueUtil.correctFloat((float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8), 0.0f, 1.0f);
            if (this.listener != null) {
                this.listener.mousePressed(this);
            }
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int par1, int par2) {
        this.dragging = false;
        if (this.listener != null) {
            this.listener.mouseReleased(this);
        }
    }

    @Override
    public void setString(String str) {
        try {
            float f = (float)Math.round(Double.parseDouble(str.replace(",", ".")) * 10.0) / 10.0f;
            str = String.valueOf(f).replace(".", ",");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.field_146126_j = NoppesStringUtils.translate(str);
    }

    @Override
    public void setDisplayString(String newDisplayString) {
        this.field_146126_j = newDisplayString;
    }

    @Override
    public float getSliderValue() {
        return this.sliderValue;
    }

    @Override
    public void setSliderValue(float value) {
        this.sliderValue = ValueUtil.correctFloat(value, 0.0f, 1.0f);
    }

    @Override
    public int getID() {
        return this.field_146127_k;
    }

    @Override
    public int[] getCenter() {
        return new int[]{this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + this.field_146121_g / 2};
    }

    @Override
    public void setHoverText(String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public int getLeft() {
        return this.field_146128_h;
    }

    @Override
    public int getTop() {
        return this.field_146129_i;
    }

    @Override
    public void setLeft(int left) {
        this.field_146128_h = left;
    }

    @Override
    public void setTop(int top) {
        this.field_146129_i = top;
    }

    @Override
    public int getWidth() {
        return this.field_146120_f;
    }

    @Override
    public int getHeight() {
        return this.field_146121_g;
    }

    @Override
    public void customKeyTyped(char c, int id) {
    }

    @Override
    public void customMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY);
    }

    @Override
    public void customMouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.func_146118_a(mouseX, mouseY);
    }

    @Override
    public boolean isVisible() {
        return this.field_146125_m;
    }

    @Override
    public void setIsVisible(boolean bo) {
        this.field_146125_m = bo;
    }

    @Override
    public boolean isEnabled() {
        return this.field_146124_l;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.field_146124_l = bo;
    }

    @Override
    public boolean isHovered() {
        return this.func_146115_a();
    }
}

